//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "lightU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TLightForm *LightForm;
//---------------------------------------------------------------------------
__fastcall TLightForm::TLightForm(TComponent* Owner)
    : TForm(Owner)
{
    XMove = 5;
}
//---------------------------------------------------------------------------
void __fastcall TLightForm::SwitchClick(TObject *Sender)
{
    if (Clock->Enabled)
        Clock->Enabled = false;

    if (LightForm->Color == clWhite)
    {
        LightForm->Color = clBlack;
        Status->Text = "Off";
    }
    else
    {
        LightForm->Color = clWhite;
        Status->Text = "On";
    }
}
//---------------------------------------------------------------------------
void __fastcall TLightForm::TrafficLightClick(TObject *Sender)
{
    if (Clock->Enabled)
        Clock->Enabled = false;

    if (Circle->Brush->Color == clGreen)
    {
        Circle->Brush->Color = clRed;
        TrafficSign->Text = "Stop";
    }
    else
    {
        Circle->Brush->Color = clGreen;
        TrafficSign->Text = "Go";
    }
}
//---------------------------------------------------------------------------


void __fastcall TLightForm::AnimateBClick(TObject *Sender)
{
    Clock->Enabled = true;
    Switch->Enabled = false;
    TrafficLight->Enabled = false;

    Circle->Brush->Color = clGreen;
    Circle->Left = Circle->Left + XMove;
    Clock->Interval = 50;

    if ((Circle->Left < 0) || (Circle->Left + Circle->Width) >
        (LightForm->ClientWidth - XMove))
        XMove = (-1) * XMove;
}
//---------------------------------------------------------------------------

void __fastcall TLightForm::QuitBClick(TObject *Sender)
{
     Application->Terminate();    
}
//---------------------------------------------------------------------------

