//---------------------------------------------------------------------------
#include <vcl.h>
#include <fstream.h>
#pragma hdrstop
#include "VLEng.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
void VLType::Initialise(AnsiString FileName)
{
int Index;
int NumItems;
TStringList *S1;
  for (Index = 0; Index < 12; Index = Index + 1)
  {
    List[Index].Title = "";
    List[Index].Author = "None";
    List[Index].Cost = 0;
  }
  NumItems = 0;
  if (FileExists(FileName))
  {
    S1 = new TStringList();
    S1->LoadFromFile(FileName);
    NumItems = S1->Count / 3;
    if (NumItems > 20)
      NumItems = 20;
    if (NumItems > 0)
    for (Index = 0; Index < NumItems; Index = Index + 1)
    {
      List[Index].Title = S1->Strings[3*Index];
      List[Index].Author = S1->Strings[3*Index + 1];
      List[Index].Cost = S1->Strings[3*Index + 2].ToDouble();
    }
    delete S1;
  }
  SelectedItem = 0;
}

void VLType::SetSelection(int SelectionNumber)
{
  SelectedItem = SelectionNumber;
}

void VLType::SetTitle(AnsiString NewBook)
{
  List[SelectedItem].Title = NewBook;
}

AnsiString VLType::GetTitle(void)
{
  return List[SelectedItem].Title;
}

void VLType::SetAuthor(AnsiString NewAuth)
{
  List[SelectedItem].Author = NewAuth;
}

AnsiString VLType::GetAuthor(void)
{
  return(List[SelectedItem].Author);
}

void VLType::SetBookCost(float NewCost)
{
  List[SelectedItem].Cost = NewCost;
}

AnsiString VLType::GetBookCost(void)
{
  return(FormatFloat("0.00",List[SelectedItem].Cost));
}

void VLType::SaveData(AnsiString FileName)
{
  TStringList *S2;
  int Index;
  S2 = new TStringList();
  for(Index = 0; Index < 20; Index = Index + 1)
  {
    S2->Add(List[Index].Title);
    S2->Add(List[Index].Author);
    S2->Add(AnsiString(List[Index].Cost));
  }
  S2->SaveToFile(FileName);
  delete S2;
}



