//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "VisLibU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
        MyVL.Initialise("VisLibData.txt");
}
//---------------------------------------------------------------------------
AnsiString TForm1::SetCaption(int ButtonId)
{
  MyVL.SetSelection(ButtonId);
  return MyVL.GetTitle();
}

void TForm1::ProcessButton(int ButtonId)
{
   CurrentTag = ButtonId;
   MyVL.SetSelection(ButtonId);
   Display->Clear();
   Display->Lines->Add("Library ticket");
   Display->Lines->Add("");
   Display->Lines->Add("Title = " + MyVL.GetTitle());
   Display->Lines->Add("Author = " + MyVL.GetAuthor());
   Display->Lines->Add("Price = " + MyVL.GetBookCost());
};

void TForm1::SetDisplay(int ButtonId)
{
   CurrentTag = ButtonId;
   MyVL.SetSelection(ButtonId);
   IdEdit->Text = MyVL.GetTitle();
   DescBox->Text = MyVL.GetAuthor();
   CostBox->Text = MyVL.GetBookCost();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::B0Click(TObject *Sender)
{
  if (!ControlPanel->Visible)
    ProcessButton(((TButton*)Sender)->Tag);
  else
    SetDisplay(((TButton*)Sender)->Tag);
  ((TButton*)Sender)->Caption = MyVL.GetTitle();
}

void __fastcall TForm1::Button13Click(TObject *Sender)
{
  ControlPanel->Visible = !(ControlPanel->Visible) ;
  Display->Clear();
  Display->Visible = !(Display->Visible);
  MyVL.SaveData("VLData.txt");
}
//---------------------------------------------------------------------------



void __fastcall TForm1::OKButtonClick(TObject *Sender)
{
  MyVL.SetTitle(IdEdit->Text);
  MyVL.SetAuthor(DescBox->Text);
  MyVL.SetBookCost(float(CostBox->Text.ToDouble()));
  switch (CurrentTag)
  {
    case 0: B0->Caption = IdEdit->Text;
            break;
    case 1: B1->Caption = IdEdit->Text;
            break;
    case 2: B2->Caption = IdEdit->Text;
            break;
    case 3: B3->Caption = IdEdit->Text;
            break;
    case 4: B4->Caption = IdEdit->Text;
            break;
    case 5: B5->Caption = IdEdit->Text;
            break;
    case 6: B6->Caption = IdEdit->Text;
            break;
    case 7: B7->Caption = IdEdit->Text;
            break;
    case 8: B8->Caption = IdEdit->Text;
            break;
    case 9: B9->Caption = IdEdit->Text;
            break;
    case 10: B10->Caption = IdEdit->Text;
            break;
    case 11: B11->Caption = IdEdit->Text;
            break;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
  B0->Caption = SetCaption(B0->Tag);
  B1->Caption = SetCaption(B1->Tag);
  B2->Caption = SetCaption(B2->Tag);
  B3->Caption = SetCaption(B3->Tag);
  B4->Caption = SetCaption(B4->Tag);
  B5->Caption = SetCaption(B5->Tag);
  B6->Caption = SetCaption(B6->Tag);
  B7->Caption = SetCaption(B7->Tag);
  B8->Caption = SetCaption(B8->Tag);
  B9->Caption = SetCaption(B9->Tag);
  B10->Caption = SetCaption(B10->Tag);
  B11->Caption = SetCaption(B11->Tag);
  Display->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::QuitButtonClick(TObject *Sender)
{
    Application->Terminate();    
}
//---------------------------------------------------------------------------

